package gov.va.med.mhv.vitals.converter;

import gov.va.med.mhv.vitals.dto.LipidsReadingDTO;
import gov.va.med.mhv.vitals.model.LipidsReading;

import java.util.ArrayList;
import java.util.List;

public class LipidsConverter {

	public static LipidsReadingDTO  convertLipidReadingDomain( LipidsReading lipidReading ){
		LipidsReadingDTO dto = new LipidsReadingDTO();
		dto.setComments(lipidReading.getComments());
		dto.setFast(lipidReading.getFast());
		dto.setHdl(lipidReading.getHdl());
		dto.setLdl(lipidReading.getLdl());
		dto.setLipidsId(lipidReading.getId());
		dto.setLocation(lipidReading.getLocation());
		dto.setProvider(lipidReading.getProvider());
		dto.setReading(lipidReading.getReading());
		dto.setTotal(lipidReading.getTotal());
		dto.setTriglycerides(lipidReading.getTriglycerides());
		return dto;
		
	}
	
	public static LipidsReading convertLipidReadingDTO(LipidsReadingDTO lipidReadingDTO){
		LipidsReading lipidReading = new LipidsReading();
		lipidReading.setComments(lipidReadingDTO.getComments());
		lipidReading.setFast(lipidReadingDTO.getFast());
		lipidReading.setHdl(lipidReadingDTO.getHdl());
		lipidReading.setId(lipidReadingDTO.getLipidsId());
		lipidReading.setLdl(lipidReadingDTO.getLdl());
		lipidReading.setLocation(lipidReadingDTO.getLocation());
		lipidReading.setOplock(0);
		lipidReading.setProvider(lipidReadingDTO.getProvider());
		lipidReading.setReading(lipidReadingDTO.getReading());
		lipidReading.setTotal(lipidReadingDTO.getTotal());
		lipidReading.setTriglycerides(lipidReadingDTO.getTriglycerides());
		lipidReading.setUserprofileId(lipidReadingDTO.getUserprofileId());
		return lipidReading;
		
	}
	
	public static List<LipidsReadingDTO>  convertLipidReadings( List<LipidsReading> lpReadings ){
		
		List<LipidsReadingDTO> dtos = new ArrayList<LipidsReadingDTO>();
		for(LipidsReading lipidReading : lpReadings){
			LipidsReadingDTO dto = convertLipidReadingDomain(lipidReading);
			dtos.add(dto);
		}
		return dtos;
	}
}
